(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     11519,        339]*)
(*NotebookOutlinePosition[     12604,        374]*)
(*  CellTagsIndexPosition[     12560,        370]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["\<\
A Simple Search Engine for an Unstructured Quantum Computing \
Database\
\>", "Title",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Colin P. Williams", "Subsubtitle",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Off[General::spell1]\)], "Input",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[TextData["Copyright Notice"], "Section",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Copyright Colin P. Williams (1997).\n\nThis Notebook is intended to be used \
in conjunction with \"Explorations in Quantum Computing\" by Colin P. \
Williams and Scott H. Clearwater, TELOS, Springer-Verlag (1997), \
ISBN:0-387-94768-X. Permission is hereby granted to copy and distribute this \
Notebook freely for any non-commercial activity provided you include this \
copyright notice at the beginning of all such copies. Please send suggestions \
and bug reports to Colin P. Williams at \n        colin@solstice.jpl.nasa.gov \
     (818) 306 6512 or \n        cpw@cs.stanford.edu               (415) 728 \
2118\nFor information on \"Explorations in Quantum Computing\" check out the \
TELOS web site:  http://www.telospub.com/catalog/PHYSICS/Explorations.html. \
To order call 1-800-777-4643.\n\nAll other rights reserved."], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["How to use this Notebook"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"This Notebook contains code for searching a database of references to papers \
in quantum computing.  The field is growing so rapidly that this database \
will surely need to be updated over the coming months.  Unlike the Los Alamos \
National Laboratory  archive (http://xxx.lanl.gov/archive/quant-ph/) this \
database contains many of the classic, older,  references on quantum \
computing and quantum communication.  We hope it will be a useful adjunct to \
the modern on-line archives.\n\nThe basic command is Search. The following \
types of query are supported:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Search[Lloyd]              (* returns all papers by Lloyd *)\nSearch[{Doyle, \
Laflamme}]  (* returns all papers by Doyle OR Laflamme *)\nSearch[Adami || \
Fahn]      (* returns all papers by Adami OR Fahn (same as previous) *)\n\
Search[Shor && Not[Code]]  (* return Shor papers not about codes *)\n\
Search[Teleport]           (* return papers containing keyword Teleport *)"], 
  "Input",
  AspectRatioFixed->True],

Cell[TextData[
"Before you can run the search engine, you will need to set your directory to \
the pathname leading to the place where you have the quantum computing \
database. For example, on my Macintosh computer I would do this with the \
command:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"SetDirectory[\"Hard Disk:Desktop Folder:Documents:Mathematica 2.2.2:EiQC \
Code\"];"], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"You need to replace the string with a string that defines a directory on \
your computer system. On UNIX systems the directory separator is \"/\" (a \
forward slash). On PCs the directory separator is \"\\\" (a backwards slash). \
Check the usage statements for the Directory and SetDirectory commands."], 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["?Directory"], "Input",
  AspectRatioFixed->True],

Cell[TextData["Directory[ ] gives the current working directory."], "Print",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["?SetDirectory"], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"SetDirectory[\"dir\"] sets the current working directory."], "Print",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Try me!"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["To find out how to use Search, type ?Search"], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["?Search", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("Search[query] returns all known citations that satisfy your query.  \
The query may consist of a single keyword, a list (implicit disjunction)  of \
keywords, or a logical sentence built out of keywords and the  infix \
operators && (for logical conjunction) and/or || (for logical  disjunction), \
and the prefix operator Not (for logical negation)."\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Try me!"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Search[Teleport]"], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"Bennett, C. H., Brassard, G., Crepeau, C., Jozsa, R., Peres, A., Wootters, \
W. K. \n\t\"Teleporting an Unknown Quantum State via Dual Classical and \
Einstein-Podolsky-Rosen Channels\"\n\tPhysical Review Letters, Vol. 70 (1993) \
pp. 1895-1899.\n\n\nBennett, C. H., Brassard, G., Popescu, S., Schumacher, \
B., Smolin, J. A., Wootters, W. K. \n\t\"Purification of Noisy Entanglement \
and Faithful Teleportation\"\n\tPhysical Review Letters, Vol. 76 (1996) pp. \
722-725.\n\n\nBennett, C. H., Brassard, G., Crepeau, C., Jozsa, R., Peres, \
A., Wooters, W., \n\t\"Teleporting an Unknown Quantum State via Dual \
Classical and Einstein-Podolsky-Rosen Channels\"\n\t Physical Review Letters, \
Vol. 70 (1993) pp.1895-1899.\n\n\nPeterson, I., \n\t\"Inspecting Teleported \
Quantum Information\"\n\tScience News, April, 1993 p. 229.\n\n\nPopescu, S. \n\
\t\"Bell's Inequality versus Teleportation: What is Nonlocality?\"\n\t\
Physical Review Letters, Vol. 72 (1994) pp.797-799.\n\n\nSudbury, T., \n\t\
\"Instant Teleportation\"\n\t Nature vol.362 (1993) pp. 586-587.\n\n"], 
  "Print",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Try me!"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Search[Deutsch && Jozsa]"], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"Deutsch, D. and Jozsa, R. \n\t\"Rapid Solution of Problems by Quantum \
Computation\"\n\tProceedings of the Royal Society of London,  Vol. 439A \
(1992) pp. 553-558.\n\n\nDeutsch, D., Ekert, A., Jozsa, R., Macchiavello, C., \
Popescu, S., Sanpera, A. \n\t\"Quantum Privacy Amplification and the Security \
of Quantum Cryptography Over Noisy Channels\"\n\tPhysical Review Letters, \
Vol. 77 (1996) pp. 2818-2821.\n\n"], "Print",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Code for Search Engine in here ..."], "Section",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Search[query_]:=
\tModule[{hits},
\t\tSetOptions[$Output, PageWidth->Infinity];
\t\tSetDirectory[\"Hard Disk:Desktop Folder:Documents:Mathematica 2.2.2:EiQC \
Code\"];
\t\thits = Lookup[\"QCdatabase.txt\", query];
\t\tIf[hits === {},
\t\t   Print[\"Sorry, no citations satisfy that query. Try re-wording it.\"],
\t\t   (* Scan[(Print[#];Print[\"\\n\\n\\n\"])&, hits] *)
\t\t   Scan[PrintCitation, hits]
\t\t  ]
\t]

Search[query_String]:=
\tSearch[ToExpression[query]]

Search::usage =
\t\"Search[query] returns all known citations that satisfy your query. \\
\tThe query may consist of a single keyword, a list (implicit disjunction) \\
\tof keywords, or a logical sentence built out of keywords and the \\
\tinfix operators && (for logical conjunction) and/or || (for logical \\
\tdisjunction), and the prefix operator Not (for logical negation).\";
\t
(* Lookup does most of the work *)\t
Lookup[database_, keyword_Symbol]:=
\tFindList[ToString[database], ToString[keyword]]

Lookup[database_, keywords_List]:=  (* implicit Or of keywords *)
\tFindList[ToString[database], Map[ToString, keywords]]
\t
Lookup[database_, keyword_ && keywords__]:=
\tApply[Intersection,
\t      Map[Lookup[database, #]&, Apply[List, keyword && keywords]]]

Lookup[database_, keyword_ || keywords__]:=
\tLookup[database, Apply[List, keyword || keywords]]
\t
Lookup[database_, Not[keyword_ && keywords__]]:=
\tLookup[database, Not[keyword] || Not[keywords]]
\t
Lookup[database_, Not[keyword_ || keywords__]]:=
\tLookup[database, Not[keyword] && Not[keywords]]
\t
Lookup[database_, Not[keyword_]]:=
\tModule[{allEntries},
\t\tallEntries = ReadList[ToString[database],
\t\t                      Record,
\t\t                      RecordSeparators->{\"\\n\"}];  (* bad for big DBs \
*)
\t\tSelect[allEntries, 
\t\t       Not[StringMatchQ[#, \"*\"<>ToString[keyword]<>\"*\"]]&]
\t]
\t
PrintCitation[citation_]:=
\tModule[{pos, startTitle, endTitle, authors, title, others},
\t\tpos = StringPosition[citation, \"\\\"\"];
\t\tIf[pos =!= {},
\t\t\t(startTitle = First[pos][[1]];
\t\t\t endTitle   = Last[pos][[1]];
\t\t\t authors = StringTake[citation, {1, startTitle-1}];
\t\t\t title   = StringTake[citation, {startTitle, endTitle}];
\t\t\t others  = StringDrop[citation, {1, endTitle+1}];
\t\t\t Print[authors];
\t\t\t Print[\"\\t\"<>title];
\t\t\t Print[\"\\t\"<>others];
\t\t\t Print[\"\\n\"]
\t\t\t),
\t\t\tPrint[citation<>\"\\n\"]
\t\t  ]
\t]
\t

(* This form of partition retains trailing elements *)\t
PartitionWithRmdr[list_, n_]:=
\tModule[{leftovers},
\t\tIf[Mod[Length[list], n] != 0,
\t\t\t(leftovers = Take[list, -Mod[Length[list], n]];
\t\t\t Join[Partition[list, n], {leftovers}]
\t\t\t),
\t\t\tPartition[list, n]
\t\t  ]
\t]\
\>", "Input",
  Editable->False,
  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 640}, {0, 460}},
AutoGeneratedPackage->Automatic,
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{611, 431},
WindowMargins->{{12, Automatic}, {Automatic, 1}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@00000000000000060801T1T000000@0000
00000000004000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 163, 6, 174, "Title",
  Evaluatable->False],
Cell[1897, 59, 107, 3, 53, "Subsubtitle",
  Evaluatable->False],
Cell[2007, 64, 81, 2, 25, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[2113, 70, 112, 3, 50, "Section",
  Evaluatable->False],
Cell[2228, 75, 921, 14, 222, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[3186, 94, 101, 2, 50, "Section",
  Evaluatable->False],
Cell[3290, 98, 642, 10, 126, "Text",
  Evaluatable->False],
Cell[3935, 110, 433, 7, 103, "Input"],
Cell[4371, 119, 310, 6, 62, "Text",
  Evaluatable->False],
Cell[4684, 127, 137, 3, 38, "Input"],
Cell[4824, 132, 380, 7, 62, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5229, 143, 63, 1, 25, "Input"],
Cell[5295, 146, 124, 2, 22, "Print",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[5456, 153, 66, 1, 25, "Input"],
Cell[5525, 156, 133, 3, 22, "Print",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[5695, 164, 90, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[5788, 168, 117, 2, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5930, 174, 50, 1, 25, "Input"],
Cell[5983, 177, 385, 5, 82, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[6417, 188, 90, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6532, 194, 69, 1, 25, "Input"],
Cell[6604, 197, 1145, 17, 498, "Print",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[7798, 220, 90, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7913, 226, 77, 1, 25, "Input"],
Cell[7993, 229, 491, 8, 190, "Print",
  Evaluatable->False]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8545, 244, 130, 3, 50, "Section",
  Evaluatable->False],
Cell[8678, 249, 2813, 86, 1104, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

